-- ScreenSelectCourse List
local bgWidth = 268
local bgHeight = 150

return Def.ActorFrame{
	Def.ActorFrame{
		Name="BG";
		Def.Quad{
			Name="Main";
			InitCommand=cmd(zoomto,bgWidth,bgHeight;diffuse,color("0,0,0,0.45");fadetop,0.125;fadebottom,0.125);
			OffCommand=cmd(linear,0.15;zoomy,0);
		};
		Def.Quad{
			Name="Left";
			InitCommand=cmd(x,-(bgWidth/2);zoomto,2,bgHeight+8;fadetop,0.1;fadebottom,0.1);
			OffCommand=cmd(sleep,0.05;linear,0.1;addx,134;sleep,0.05;linear,0.1;zoomy,0);
		};
		Def.Quad{
			Name="Right";
			InitCommand=cmd(x,bgWidth/2;zoomto,2,bgHeight+8;fadetop,0.1;fadebottom,0.1);
			OffCommand=cmd(sleep,0.05;linear,0.1;addx,-134;sleep,0.05;linear,0.1;zoomy,0);
		};
	};

	-- and now the hard part.
	-- todo: make this not SUCK.
	Def.CourseContentsList {
		MaxSongs = 30; -- any course with over 30 songs?? idk
		NumItemsToDraw = 3.15;
		SecondsPerItem = 1.5;
		SetCommand=function(self)
			self:finishtweening();
			self:SetFromGameState();
			self:setsize(bgWidth,160);
			self:SetCurrentAndDestinationItem(1);
			-- todo: only true if course has > 3 songs.
			-- xxx: allows weird setups to happen (Song 3, Song 1, Song 2)
			local course = GAMESTATE:GetCurrentCourse();
			if course:GetEstimatedNumStages() < 4 then
				self:SetLoop(false);
			else
				self:SetLoop(true);
				self:scrollthroughallitems();
			end;
		end;
		CurrentCourseChangedMessageCommand=function(self)
			local course = GAMESTATE:GetCurrentCourse();
			self:visible( course and true or false );
		end;
		CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");

		Display = Def.ActorFrame{ 
			InitCommand=cmd(setsize,bgWidth,48);

			Def.TextBanner {
				InitCommand=cmd(Load,"CourseDisplayTextBanner";SetFromString,"", "", "", "", "", "");
				SetSongCommand=function(self, params)
					if params.Song then
						self:SetFromSong( params.Song );
						self:diffuse( SONGMAN:GetSongColor(params.Song) );
					else
						self:SetFromString( "??????????", "??????????", "", "", "", "" );
						self:diffuse( color("#FFFFFF") );
					end
				end;
				OffCommand=cmd(linear,0.1;diffusealpha,0);
			};

			LoadFont("_dejavu sans Bold 24px")..{
				Name="SongNum";
				InitCommand=cmd(xy,-129,-19;shadowlength,1;halign,0;zoom,12/24;NoStroke;diffuse,color("1,1,0,1");diffusebottomedge,color("1,0.5,0,1"));
				SetSongCommand=function(self, params) 
					self:settextf("%02i", params.Number);
				end;
				OffCommand=cmd(linear,0.1;diffusealpha,0);
			};
			LoadFont("_francophilsans Bold 24px")..{
				Name="SongMods";
				InitCommand=cmd(xy,-104,-19;shadowlength,1;halign,0;zoom,12/24;NoStroke;maxwidth,384;diffusebottomedge,color("0.8,0.8,0.8,1");skewx,-0.1);
				SetSongCommand=function(self, params) 
					self:settext(params.Modifiers);
				end;
				OffCommand=cmd(linear,0.1;diffusealpha,0);
			};

			LoadFont("_loaded 32px")..{
				Name="Meter";
				Text="0";
				InitCommand=cmd(xy,128,-18;halign,1;zoom,20/32;shadowlength,1;);
				SetSongCommand=function(self, params)
					if params.PlayerNumber ~= GAMESTATE:GetMasterPlayerNumber() then return end
					self:settext( params.Meter );
					local curCourse = GAMESTATE:GetCurrentCourse()
					if curCourse then
						local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber())
						if trail then
							local diff = GetCustomDifficulty(trail:GetStepsType(), params.Difficulty, curCourse:GetCourseType())
							self:diffuse( CustomDifficultyToColor(diff) );
						end
					end
				end;
				OffCommand=cmd(linear,0.1;diffusealpha,0);
			}; 

			Def.Quad{
				Name="SongSplitter";
				InitCommand=cmd(y,20;diffusealpha,0.65;zoomto,268,2;ztest,true;fadeleft,0.1;faderight,0.1);
				OffCommand=cmd(linear,0.1;zoomx,0);
			};
		};
	};

	Def.ActorFrame{
		Name="Overs";
		Def.Quad{
			Name="TopFade";
			InitCommand=cmd(y,-(bgHeight/2)-4;zoomto,bgWidth-2,16;valign,0;fadebottom,0.75;diffuse,color("0,0,0,0.625"));
			OffCommand=cmd(linear,0.1;zoomy,0);
		};
		Def.Quad{
			Name="BottomFade";
			InitCommand=cmd(y,(bgHeight/2)+4;zoomto,bgWidth-2,16;valign,1;fadetop,0.75;diffuse,color("0,0,0,0.625"));
			OffCommand=cmd(linear,0.1;zoomy,0);
		};
	};
};